SHADES OF WORDSTAR
Some WordStar Interfile Techniques
by Dick Ezzard

One breakthrough for a writer working on word processor comes 
when he unshackles himself from the habit of most always working 
on the tail end of a writing project -- a habit grooved and re-
grooved because with a typewriter (or quill pen), the tail end is 
always the most convenient place to work.  That's where the blank 
paper is.  

What does phonetic writing represent?  The networks of my 
thoughts are multi-colored, many-dimensioned, infinitely 
interconnected, and instantly associated and re-associated 
according to my own idiosyncratic learning experiences.  Compared 
to the intricate, immense, technicolor, 3D, living web of human 
thought, text extruded by a typewriter or even a word processor 
is a poor, skinny, little worm, -- an essentially linear 
artifact.  Like typewriter text, a WordStar file is a string of 
characters with various knots such as word spacings, line endings 
and paragraph endings tied into the string.  

But just as a reference book permits multiple easy access at any 
point for reading, so does the word processor instrument 
facilitate access to text at any point --at infinite points-- for 
writing.  The text string can be cut into and re-arranged and new 
knots can be tied effortlessly.  Re-arrangement and interjection 
operations in the paper-and-ink world are cumbersomely involved 
with note slips and note cards and physical cutting and pasting 
but they come easy with a word processor.  (Deletion is almost 
too easy!)  

The freed-up writer learns the use of place-markers to jump 
around and work throughout an entire WordStar file -- instead of 
merely adding on to a string's tail end.  The writing process 
becomes much more like blocking out and filling in.  You get to 
write in the middle and at the beginning as well as at the tail 
end.  

The second breakthrough comes when the writer enlarges his canvas 
by one more dimension:  Instead of working throughout a single 
file, he works all over the system!  Even though WordStar will 
suck you into one-file operations, there is no need to so 
stultify yourself.  You can easily work in two or more files 
simultaneously.  You can append notes to the end of another file.  
You can quickly glance at an outline.  You can work all over the 
disk, indeed, you can work all over the system.  And it doesn't 
take a new high-cost program to do these things, just the 
application of your own human technique to available WordStar 
interfile power.  

Avoid file focus!  Try to make it a habit to work in two or more 
files simultaneously.  

This technique is especially valuable when you are working on 
some writing of a certain heft, something more than just a simple 
letter, some kind of ... Project.  One problem with computers is 
the tiny periscope view which forces us to focus on the current 
segment of text rather than the context.  A sweeping panoramic 
overview is difficult.  Since layout of an entire complex project 
may be difficult to hold in the mind's eye, it is often useful, 
sometimes essential, to have a jotted outline to refer to when 
you are working on a mural-sized piece, so you can momentarily 
step back for a full project overview.  

Let's say you are writing along, finish a segment, and need to 
glance at the outline of your project to see where to go next.  
You hit a special function key and your outline comes into view.  
After browsing, finding out what you wanted to know, you hit a 
couple of keys and the outline goes away again.  

Okay, many of the newer, more elaborate word processing programs 
boast a "windows" feature.  Windowing allows you look at two (or 
more) files simultaneously, work in either or both, yet maintain 
separate identities for filing on the disk.  Typical uses for a 
window feature are to glance at an outline file when working on 
text (just what we're talking about here), or to jot down 
something which is not germane to your main effort of the moment 
by jotting in a separate "Odd Notes" file.  

While WordStar does not have a specific windowing capability, 
ingenuity lets you achieve the same logical effects with an 
"almost windows" facility I'll call "Window Shades."  Shades 
technique has the metaphorical effect of (while working in a main 
file) pulling down a shade with a message written on it (such as 
your outline).  You can look at the outline, then snap the shade 
back up out of the way and go back to working in your regular 
window.  

Shades starts with WordStar's regular ^Kr command which will 
bring any other file into the file you are working in.  The 
simple ^Kr file read command, however, once executed does not 
differentiate between the stuff that belongs to the file you are 
working in and the material you have brought over from the other 
file.  It may be bothersome to have extraneous bits and pieces of 
the outline "welded" into your text where it is hard to strip out 
again.  

The technique part involves thinking ahead, to be prepared for 
what you will want to do later, which is erase!  The solution is 
to bring the extraneous matter in as a marked block.  Then you 
can easily see on the screen what is the outline you are 
referring to and what is your text file.  And as soon as you have 
glanced at the outline, you can erase it with a ^Ky and go back 
to what you were doing.  So you want to pull your shade down as a 
segregated marked block.  

To do that, you pre-mark a tiny block into which you read the 
reference file.  Use ^Kb, <return>, ^Kk, ^Qb (puts cursor into 
the currently marked block) and then do ^Kr to bring in your 
reference material.  It comes in already marked as a block.  When 
you are done looking at it, ^Ky snaps the shade back up by 
erasing it in the file in which you are currently working.  (It 
still exists for repeated reference in its own file and you can 
glance at it again anytime by just repeating the operation.)

Because  the operation is a little complicated, if you are going 
to do shades a lot, you will want to automate the whole thing by 
setting up a pre-programmed special function key to cascade the 
WordStar commands involved.  Many systems allow for programming 
function keys.  Another alternative is to use a special program 
such as SmartKey I or II, ManyKey, ProKey, QuikKey, etc., to work 
in conjunction with WordStar.  

The keystrokes you want to put into a special function key 
are as follows:

     ^Kb<CR>^Kk^Qb^KrO<CR>

where <CR> stands for the RETURN key or ENTER key.  

To use this special function key properly you have to pre-set 
your reference outline file in a file called "O" which is the 
file always read in by this particular sequence.  Properly 
installed, when you hit this special function key, bang, in comes 
your outline as a marked block, just like pulling down a shade in 
front of your main file.  As mentioned previously, ^Ky gets rid 
of it again.  And you are right where you were before pulling 
down the shade.  

Before you install a special function key, you may want to give 
youself a walkthrough demonstration, slow test the operation "by 
the numbers."  Put something in a file called O and then see how 
easy it is to bring it in, glance at it, and erase it.   

The technique involved, your own mental ju-jitsu, is first to 
always keep the outline of your current project in a file called 
O.  (Different outlines from different files on different disks 
can be easily swapped into your O file at the start of a writing 
session.)  And secondly, because you will just want to glance at 
it momentarily, you bring the shade down prepared for easy 
erasure by pre-marking the block.  Human foresight and WordStar 
tools together yield the desired effect.  

You can also, of course, rig a similar key to expedite writing 
notes out to another file.  Let's say that your application 
requires that you keep a separate set of footnotes or endnotes to 
each chapter.  As you are writing along, you write a note or a 
citation which has to be sent to the endnote file.  You mark the 
note as a block and hit a special function key which brings in 
the note file, integrates the new note at the bottom of the 
notefile, writes the whole thing back out and erases the note in 
your current text file.  

In this case, you write something to be included in the "shade" 
which gets pulled down and snapped up automatically.  The 
technique:  
     1)  Write your note wherever you happen to be in the current 
text file.  
     2)  Do ^Kb to mark the beginning of the note, then 
immediately hit <return> to push the note down one line.  Go to 
the end of your note, hit <return> and mark ^Kk (block end).  
Your note is now configured as a block with a blank line at the 
top, and a line ending included at the bottom.  
     3)  ^Qb puts the cursor at the top of the note on that blank 
line.  
     4)  Read in your note file, ^Kr (it comes "into" the block) 
and immediately write it back out again.  That's Kw back to the 
same filename, and Y for yes to overwrite that file.  
     5)  ^Ky to erase the block in your text file, away goes the 
note.  

Steps 3, 4, and 5 can be automated with the following programmed 
special function key:

     ^Qb^KrN<CR>KwN<CR>Y^Ky

which will always bring in a file called N and overwrite out to a 
the file called N.  All you have to remember is to keep your 
current notes file in a file called N.  

This same technique works even if you are not intentionally 
keeping a separate footnote/endnote file.  Say you are working on 
a current project and a thought occurs about something off point 
that you'll want to keep for future reference.  Jot it down in a 
block and hit your notes key.  Bang, it's gone from your current 
text, saved in your notes file.  

If you absolutely need to look at two (or more) files 
simultaneously, rig a special function key to print a marked 
block, pull down the shade (like your outline), hit this new 
special function key, then rip the outline out of your printer 
and tape it up next to the screen.  ^Ky gets the shade out of 
your way on the screen.  A special function key which cascades 
the commands to accomplish instant printing of a marked block is:  

     ^KwP<CR>Y^KpP<ESC>

You can see that this command set writes any marked block 
(possibly your outline pulled down as described) out to a special 
file called P for printing, and immediately prints it.  The "Y" 
is in there to answer "Yes" to the overwrite query WordStar will 
give you if a previous P file exists on your disk.  (And if one 
does not exist, the single character "Y" will be entered in your 
file, a relatively harmless effect.)

One final comment:  Although these commands work just fine with 
WordStar on a regular system, there is some slight delay for disk 
accesses as WordStar writes back and forth to files, perhaps has 
to load up part of the overlay file to get going.  Where cascaded 
commands on programmed special function keys really come into 
their own is when you operate WordStar on a RAM disk, either a 
portion of memory configured as a disk or an add-on piece of 
hardware like the Drive C sold for the Osborne computers.  With 
that kind of setup you get snappy shades indeed.  

In conclusion, although WordStar has no separate windows, 
ingenuity will allow most people to get along with pull down 
"shades" to glance at other files.  Perhaps the most important 
thing to be learned from this is that when working with WordStar 
you should AVOID FILE FOCUS.  Don't get stuck in the habit of 
working on the tail end of only one file at a time.  There are 
many techniques that allow you to work in several files 
simultaneously, and if you break typewriter tunnel vision habits, 
you can work all over your system, writing to several files on 
any disk in any one session.  

END OF ARTICLE "SHADES OF WORDSTAR."
.pa
