                 Patching TFM Kerning Values in WordStar 6.5
                            American Version ONLY
                        by Rich Zuris [WSI] 76702,520

These patches allow you to change the way WordStar evaluates kerning 
information from tagged font metrics (TFM) files for the HP LaserJet III 
printers.  Normally, WordStar ignores kerning information for pairs that 
are kerned with values between 7 and -7.  If this loss of detail is 
noticeable to you, you may disable this filtering entirely or simply choose 
new limits.  Patching instructions are provided for each alternative.  

WARNING:  Reducing or eliminating the truncation will increase the size of 
your custom database (*.DTU) and PDF.  Since these patches have not been 
tested by WordStar Quality Assurance, unpredictable results may occur; send 
anomaly reports to WordStar technical support along with the patched 
WINSTALL.EXE file, your DTU database, and PDF.  Note that there are *two* 
different WINSTALL.EXE files included in Revision E.  The uncompressed 
version from the floppy diskettes is 271,912 bytes.  The version that is 
originally compressed but is decompressed and installed by WSSETUP is 
324,648 bytes.  Be sure to check carefully which version you have.

RECOMMENDATION:  Do NOT disable the filtering of kerning pairs entirely.  
Your PDF size will bloat, limiting the number of fonts that you can use.  
Instead, change the filter value to +/- 2 per the second set of instructions 
below (values of 02 and FE).  This should allow all "noticeable" kerning 
values into the PDF while filtering out those that have little noticeable 
impact on printed documents but take up much PDF space.


To allow all TFM kern pairs in WordStar:

         What you'll see            What you'll enter
         ---------------            -----------------
         C:\WS>                     ren winstall.exe win
         C:\WS>                     debug win
         -                          rds
         DS xxxx                    (Add 3000 to this value and enter the
         :                          result; e.g., if 2B35, enter 5B35.)

                                    (Choose appropriate version)
         -                          e 8d5c eb 08  (for WS 6.0 Rev @ or B)
         -                          e 9712 eb 08  (for WS 6.0 Rev C)
         -                          e b456 eb 08  (for WS 6.0 Rev D)
         -                          e be56 eb 08  (for WS 6.0 Rev E large)
         -                          e a856 eb 08  (for WS 6.0 Rev E small)

                                    (For all versions)
         -                          w
         Writing xxxxx bytes
         -                          q
         C:\WS>                     ren win winstall.exe
         C:\WS>


To limit kerning information to a specific range of values:

         What you'll see            What you'll enter
         ---------------            -----------------
         C:\WS>                     ren winstall.exe win
         C:\WS>                     debug win
         -                          rds
         DS xxxx                    (Add 3000 to this value and enter the
         :                          result; e.g., if 2B35, enter 5B35.)

                                    (Choose appropriate version)
         -                          e 8d5d  (for WS 6.0 Rev @ or B)
         -                          e 9713  (for WS 6.0 Rev C)     
         -                          e b457  (for WS 6.0 Rev D)     
         -                          e be57  (for WS 6.0 Rev E large)
         -                          e a857  (for WS 6.0 Rev E small)

                                    (For all versions)
         xxxx:xxxx  07.             (Enter upper limit for truncation; e.g.,
                                    if you wish to include values GREATER 
                                    THAN +4 in kerning tables, enter 04.)

                                    (Choose appropriate version)
         -                          e 8d62  (for WS 6.0 Rev @ or B)
         -                          e 9718  (for WS 6.0 Rev C)     
         -                          e b45c  (for WS 6.0 Rev D)     
         -                          e be5c  (for WS 6.0 Rev E large)
         -                          e a85c  (for WS 6.0 Rev E small)

                                    (For all versions)
         xxxx:xxxx  F9.             (Enter lower limit for truncation using
                                    the table below; e.g. for -4, enter FC.)
         -                          w
         Writing xxxxx bytes
         -                          q
         C:\WS>                     ren win winstall.exe
         C:\WS>

Use this table to determine the hexadecimal value for the lower limit used 
in truncating kerning information above:

         To include kern 
         values LESS THAN:          Enter this hex value:
         -----------------          ---------------------
                -1                           FF
                -2                           FE
                -3                           FD
                -4                           FC
                -5                           FB
                -6                           FA


WARNING:  Do NOT mix these two sets of instructions.  If at one time you 
want to disable the table entirely and later decide to simply change the 
truncation limits, start with a new copy of WINSTALL.EXE from your 
distribution disk.
