(*
    WSCONV : Converter to convert wordstar file to RTF/HTML/TXT 
    Copyright (C) 2000  Yohanes Nugroho

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Yohanes Nugroho (yohanes_n@hotmail.com)
    Kp Areman RT 09/08 No 71
    Ds Tugu Cimanggis
    Bogor 16951
    Indonesia
*)

program ws_converter;
(*
 file converter WORDSTAR to TEXT, HTML, and RTF
 compile this file with BP7/TP7/DELPHI3

 EXPLANATION

 The WS program is still popular in Indonesia. There
 are many courses for the program, books mention that
 there are problems with WS as it doesn't recognise
 new file formats, and many new programs don't know
 about WordStar's file format either. Because of this
 it is difficult to change WordStar files to better
 known formats, like MS Word. To get around this you
 may be forced to save your WordStar file as simple
 text.

 This program can change your WordStar file from WS
 format into TEXT, HTML, and RTF. Everyone can read
 TEXT format documents, HTML format (Hyper-Text Mark-
 up Language) files can be opened using a Web browser
 (like Lynx, Netscape, and IE), and RTF (Rich Text
 Format) can be opened by basic Windows programs like
 WordPad, or other programs like MS Word.

  Program  ini  memiliki  berbagai
 keterbatasan, antara lain sedikitnya perintah titik
 ws (dot command)  yang dikenal,  hilangnya beberapa
 kontrol cetak, dll. Namun program ini  dapat  mena-
 ngani hal-hal yang penting  seperti header parsing,
 symmetrical control code handling, dan kontrol teks
 yang sering dipakai ( bold, double, underline, sub-
 script, strike (coret), italics(miring), dan super-
 script). File hasil  biasanya  masih  perlu sedikit
 pengeditan untuk menyesuaikan dengan file aslinya.

 Penanganan  warna belum dites di printer yang asli,
 sehingga  pada  defaultnya fasilitas ini  dimatikan
 namun ada opsi untuk menyalakannya.

 >>>> CATATAN PENTING : <<<<
 file WS versi < 5 tidak punya header  yang membeda-
 kannya dari format file  lain, jika file input  ti-
 dak   memiliki   header  yang  sesuai dengan header
 wordstar maka file tersebut  dianggap  sebagai file
 dari ws versi < 5.  Hati-hati, jika  file  tersebut
 buka file ws, mungkin akan muncul pesan error dalam
 proses pengubahannya.

 Terima Kasih buat:
 * Tuhan yang memberi saya hidup
 * Seluruh keluarga
 * Teman-teman di Informatika ITB 98 terutama Indah Astuti
   yang telah meminjamkan komputernya untuk pembuatan program
   database OSKM ITB dan untuk pembuatan program ini

    * WS-CON 1.01 *

    (c) Mei 1999 Yohanes Nugroho
        sebuah produk dari Caecilia Tech.
        Bogor 27/28 Mei 1999 (versi delphi 21/7/1999)

        - email   : yohanes@biosys.net, yohanes_n@hotmail.com
        - website : http://langitbiru.hypermart.net
          (program bisa didownload di website saya jika Anda malas mengetik)
        - Rumah   :
                    Kp Areman RT 09/08 No 71 Ds Tugu
                    Cimanggis Bogor 16951
        - Kost    :
                    Sangkuriang 27 Bandung 40135
    Versi 1.01 : perbaikan bug kecil (stdin/stdout diclose 2 kali)

    * WS-CON 1.02 *

    Conversion to English prompts and fix bug that prevented last
    line of help screen from displaying.

    Jan 2001 Michael Petrie
    Compiled with Delphi 4

    - email     : mike@petrie.u-net.com
    - website   : http://www.wordstar.org / http://www.petrie.u-net.com

 *)

{$IFDEF WIN32}
        {$APPTYPE CONSOLE}
uses Sysutils;
{$ELSE}
uses dos;
{$ENDIF}

const BUFFER_SIZE = 63*1024;

type ws_header = record
     head_tag  : array [0..3] of char;
     version   : byte;
     driver    : array [0..8] of char;
     res       : word;
     filestart : longint;
     filler    : array [0..107] of char;
     end;
type tabstruc       = record
     tabsizeHMI     : word;
     abstabsizeHMI  : word;
     tabtype        : byte;
     tabsize        : byte;
     end;

type IObuffer   = array [0..BUFFER_SIZE] of char;
     PIObuffer  = ^IObuffer;
const {HTML tags}
     {bold,double,underline,super,sub,strike,italics}
     printstate   :       array [1..7] of boolean =
                          (false,false,false,false,false,
                          false,false);
     printTagHTML :       array [1..7] of string[6]=
                          ('B','B','U','SUP','SUB','STRIKE','I');
     printTagRTF  :       array [1..7] of string[6] =
                          ('b','b','ul','super','sub','strike','i');
     {0 - Black, 1 - Blue,2 - Green,	3 - Cyan,4 - Red,
     5 - Magenta,6 - Brown,7 - Light Grey,8 - Dark Grey,
     9 - Light Blue, 0AH - Light Green, 0BH - Light Cyan,
     0CH - Light Red, 0DH - Light Magenta,0EH - Yellow
     0FH - White on black( HTML don't use)}

     {
     the colour is not a correct match, do we know the correct one?
     not sure: content taken from Java Script
     }
     colors : array [0..15] of string[6] =
                           ('000000','0000FF','00FF00','00FFFF','FF0000',
                            'FF00FF','A52A2A','D3D3D3','A9A9A9','ADD8E6',
                            '90EE90','E0FFFF','EE9090','FFE0FF','FFFF00',
                            '000000');
     DstType : array [0..2] of string[13] =
                             ('text file','html document','rtf document');



{error messages}
     msg_filenotfound = 'file not found ';
     msg_canceled     = 'operation cancelled';
     msg_destexist    = 'file already exists, overwrite';
     msg_destnameerr  = 'destination filename cannot be same as source filename';
     msg_desttypeerr  = 'destination type error';
     msg_fail2opsrc   = 'cannot open source file';
     msg_fail2opdest  = 'cannot open destination file';
     msg_notenoughmem = 'not enough memory';
     msg_errorread    = 'file read error';
     msg_errorwrite   = 'file write error';

var f           :       file;
    fout        :       file;
    si,so       :       text; {standard input/ouput}
    head        :       ws_header;
    buffer      :       PIObuffer;
    bufferout   :       PIObuffer;
    {$IFDEF WIN32}
    bufflen     :       longint;
    {$ELSE}
    bufflen     :       word;
    {$ENDIF}
    buffidx     :       word;
    fsize       :       longint;
    charidx     :       longint;
    outidx      :       longint;
    outcharidx  :       longint;
    deftab      :       word;
    lastisret   :       boolean; {last character is return?}
    lastisspc   :       boolean; {last character is a space?}
    justify     :       byte;    {left center right}
    srcname     :       string;
    destname    :       string;
    desttype    :       integer;  {text html rtf}
    modesr      :       boolean;
    ignoreclr   :       boolean;
    readheader  :       boolean;
    unixtext    :       boolean;

{help function}
function formatnumber(n : longint):string;
const delim  = ',';
var s      : string;
    b,c,l  : byte;
begin
     str(n,s);
     l:=length(s);
     formatnumber:=s;
     if l<4 then exit;
     c:=0;
     for b:=l downto 1 do
         begin
              inc(c);
              if ((c mod 3) = 0) and (b<>1) then
                 insert(delim,s,l-c+1);
         end;
     formatnumber:=s;
end;

procedure exitError(msg:string;errcode:byte);
begin
     writeln(so,'Error: '+msg);
     {$I-}
     close(so);
     close(si);
     {$I+}
     halt(errcode);
end;

{$IFNDEF WIN32}
function fileExists(fn:string):boolean;
var
     T : SearchRec;
begin
     findFirst(fn,$3F,t);
     fileExists:=doserror=0;
end;
{$ENDIF}

Function ask(msg:string):boolean;
var  ans : string;
begin
     ans:='';
     repeat
           write(so,msg,' [y/n] ');readln(si,ans);
     until upcase(ans[1]) in ['Y','N'];
     ask:=upcase(ans[1])='Y'
end;

function left(s:string;num:byte):string;
begin
     left:=copy(s,1,num);
end;

function scan(s:string;teks:string):boolean;
begin
     scan:=pos(teks,s)>0;
end;

function uppercase(s:string):string;
var st:string;
    b:byte;
begin
     st:=s;
     for b:=1 to length(st) do st[b]:=upcase(st[b]);
     uppercase:=st;
end;

function num2str(l:longint):string;
var  s : string[12];
begin
     str(l,s);
     num2str:=s;
end;

function b2hex(a:byte):String;
const
     tabelhex : array[0..15] of char='0123456789ABCDEF';
begin
     b2hex:=tabelhex[(a and $f0) shr 4]+tabelhex[a and $0f];
end;

function space(num:byte):string;
var s:string;
begin
{$IFDEF WIN32}
     setlength(s,num);
{$ELSE}
     s[0]:=chr(num);
{$ENDIF}
     fillchar(s[1],num,' ');
     space:=s;
end;

procedure openFile(innm,outnm:string);
begin
     assign(f,innm);
     assign(fout,outnm);
     {$I-}
     reset(f,1);
     {$i+}
     if IOresult<>0 then
        exitError(msg_fail2opsrc,5);
     {$I-}
     rewrite(fout,1);
     {$I+}
     if IOresult<>0 then
        exitError(msg_fail2opdest,5);
end;


procedure closeFiles;
begin
     {$I-}
     close(f);
     close(fout);
     {$I+}
end;

function mygetmem(size:word):pointer;
var buff:pointer;
begin
     buff:=nil;
     {$IFNDEF WIN32}
     if (maxavail<2*(BUFFER_SIZE+1)) then
        exitError(msg_notenoughmem,6);
     {$ELSE}
     try
     {$ENDIF}
           getmem(buff,size);
     {$IFDEF WIN32}
     except
           exitError(msg_notenoughmem,6);
     end;
     {$ENDIF}
     mygetmem:=buff;
end;

procedure initData;
begin
     buffidx:=BUFFER_SIZE+1;
     bufflen:=BUFFER_SIZE;
     charidx:=0;
     outcharidx:=0;
     outidx:=0;
     fsize:=filesize(f);
     readheader:=(fsize>=128);
     deftab:=8;
     lastisret:=true;
     justify:=0;
     buffer:=mygetmem(BUFFER_SIZE+1);
     bufferout:=mygetmem(BUFFER_SIZE+1);
     fillchar(buffer^,BUFFER_SIZE+1,0);
     fillchar(bufferout^,BUFFER_SIZE+1,0);
     fillchar(head,sizeof(head),0);
end;

procedure freeMemory;
begin
     freemem(buffer,BUFFER_SIZE+1);
     freemem(bufferout,BUFFER_SIZE+1);
end;

procedure fatalError(msg:string;errcode:byte);
begin
     freeMemory;
     closeFiles;
     exitError(msg,errcode);
end;

procedure readWsHeader;
begin
     seek(f,0);
     {$I-}
     blockread(f,head,sizeof(ws_header));
     {$I+}
     if IOresult<>0 then fatalError(msg_errorread,7);
end;

function strcmp(s:string; var b):boolean;
type arr = array [1..255] of char;
{for compatability due to differing pascal versions}
var  i:byte;
begin
     strcmp:=false;
     for i:=1 to length(s)
         do if s[i]<>arr(b)[i] then exit;
     strcmp:=true;
end;


procedure printHeaderInfo;
var ws_ver : string [3];
    i      : byte;
begin
     writeln(so);
     writeln(so,'WordStar file opened: ');
     if (not strcmp(#$1D#$7D#0#0,head.head_tag)) then
        begin
             writeln(so,'WordStar file format ver < 5');
             seek(f,0);
             exit;
        end;
     with head do
          begin
               ws_ver := chr((version and $f0) shr 4+$30)+'.'
                       + chr((version and $0f)+$30);
               writeln(so,' * WorStar version  : ',ws_ver);
               write(so,' * printer driver   : ');
               i:=0;
               while (driver[i]<>#0) and (i<9) do
                     begin
                     write(so,driver[i]);
                     inc(i);
                     end;

               writeln(so);
          end;
     writeln(so,' * file size        : ',filesize(f),' bytes');
end;

{get one character from stream buffer}
function getChar:char;
begin
     inc(charidx);
     inc(buffidx);
     if (buffidx>bufflen-1) then
        begin
             {$I-}
             blockread(f,buffer^,BUFFER_SIZE+1,bufflen);
             {$I+}
             if IOresult<>0 then fatalError(msg_errorread,7);
             buffidx:=0;
        end;
     getchar:=buffer^[buffidx];
end;

{get one word from stream buffer}
function getWord:word;
begin
     getWord:=byte(getChar)*256+byte(getchar);
end;

{skip n characters}
procedure skipbyte(step : byte);
var b : byte;
begin
     for b:=1 to step do getChar;
end;

{send one character to stream buffer}
procedure putChar(c:char);
begin
     lastisret:=(c=#$0a);
     lastisspc:=(c=' ');
     if (unixtext) and (c=#$0d) then exit;
     bufferout^[outidx]:=c;
     inc(outidx);
     inc(outcharidx);
     if (outidx=BUFFER_SIZE+1) then
        begin
        {$I-}
             blockwrite(fout,bufferout^[0],BUFFER_SIZE+1);
        {$I+}
             if IOresult<>0 then fatalError(msg_errorwrite,7);
             outidx:=0;
        end;
end;

procedure writebuff(s:string);
var b : byte;
begin
     for b:=1 to length(s) do putchar(s[b]);
end;

procedure writelnbuff(s:string);
begin
     writebuff(s+#$0d#$0a);
end;

{flush buffer to disk}
procedure flushOutput;
begin
     {$I-}
     blockwrite(fout,bufferout^,outidx);
     {$I+}
     if IOresult<>0 then fatalError(msg_errorwrite,7);
end;

{end of stream buffer}

{**********************************************************}
{convert to TXT}
function defaultConvert(c :char):boolean;
begin
     if ((c in [#32..#127]) and (c<>'.')) then
        begin
             defaultConvert:=true;
             putchar(c);
        end else
             defaultConvert:=false;
end;

procedure handleTab;
var tabs : tabstruc;
begin
     with tabs do
          begin
               tabsizeHMI:=getWord;
               abstabsizeHMI:=getWord;
               tabtype:=byte(getChar);
               tabsize:=byte(getChar);
          end;
     writebuff(space(tabs.tabsize));
     skipbyte(3);{skip symetric seq}
end;

{
Clear unused characters and write to file.
Only problems are dot commands.
}
procedure convertToText;
var c     : char;
    skip  : word;
begin
     c:=' ';
     while ((charidx<fsize) and (c<>#26)) do
           begin
                c:=getchar;
                if (not defaultConvert(c)) then
                case c of
                #$1b      :    begin
                                    putChar(getChar);
                                    skipbyte(1);
                               end;
                #$a0      :    putChar(' ');
                #$0d,#$0a :    putChar(c);

                #$8d,#$8a :    putChar(char(byte(c) and $7F));
                #$1d      :    begin
                                    skip:=getWord;
                                    c:=getchar;
                                    if c=#9 then handleTab else
                                    skipbyte(skip-1);
                               end;
                #$1f      :    putchar('-');
                '.'       :    if lastisret then
                                  begin
                                       repeat until (getchar=#$0a);
                                  end
                                  else putchar('.');

                end;
           end;
end;
{**********************************************************}
{convert to html}
function normalHTML(c :char):boolean;
begin
     normalHTML:=false;
     if pos(c,'<>&" ')>0 then exit;
     if ((c in [#32..#127]) and (c<>'.')) then
        begin
             normalHTML:=true;
             putchar(c);
        end;
end;

procedure handleTabHTML(mode:boolean);
var tabs : tabstruc;
    b    : byte;
begin
     with tabs do
          begin
               tabsizeHMI:=getWord;
               abstabsizeHMI:=getWord;
               tabtype:=byte(getChar);
               tabsize:=byte(getChar);
          end;
     if not mode then
     for b:=1 to tabs.tabsize do
         writebuff('&nbsp;');

         skipbyte(3);{skip symetric seq}
end;

procedure handleHTMLColor;
var b:byte;
begin
     if ignoreclr then
     begin
          skipbyte(5);
          exit;
     end;
     b:=byte(getChar);
     getChar;
     if b in [0..15] then
        writebuff('<font color=#'+colors[b]+'>');
     skipbyte(3);
end;

procedure specialCharHTML(c:char);
const specchar = '<>&" ';
const repwith : array [1..5] of string =
      ('&lt;','&gt;','&amp;','&quot;','&nbsp;');
begin
     if ((c=' ') and (not lastisspc)) then
        begin
             putchar(' ');
             exit;
        end;
     writebuff(repwith[pos(c,specchar)]);
end;

function handleSymmetricCode(c: char; mode:boolean):boolean;
begin
     handleSymmetricCode:=false;
     case c of
          #1         : begin
                            handleHTMLcolor;
                            handleSymmetricCode:=true;
                       end;
          #9         : begin
                            handleTabHTML(mode);
                            handleSymmetricCode:=true;
                       end;
          end;
end;

procedure handleHTMLstyle(c:char);
const controlInfo =#2#4#$13#$14#$16#$18#$19;
var   b : byte;
begin
     b:=pos(c,controlinfo);
     printstate[b]:=not printstate[b];
     if printstate[b] then writebuff('<'+printTagHTML[b]+'>') else
        writebuff('</'+printTagHTML[b]+'>')

end;

procedure handleDotCommandHTML;
var s : string;
    c : char;
begin
     s:='';
     c:=getChar;
     s:=s+c;
     while c<>#$0a do
           begin
                c:=getChar;
                if not (c in [#$0a,#$0a]) then s:=s+c;
           end;
     s:=upperCase(s);
     if left(s,2)='OC' then
        if scan(s,'ON') then writebuff('<CENTER>')
        else if scan(s,'OFF') then
             writebuff('</CENTER>');
     lastisret:=true;
end;

procedure convertToHtml(normal:boolean);
var c:char;
    skip:word;
begin
     {create HTML header}
     writelnbuff('<HTML>'#13#10'<HEAD>');
     writelnbuff('<meta http-equiv="Content-Type"');
     writelnbuff('content="text/html; charset=iso-8859-1">');
     writelnbuff('<!-- Created from a WordStar file by WS-CON>');
     writelnbuff('<!-- WS-CON 1.01 (c) 1999 Yohanes Nugroho>');
     writelnbuff('<!-- product of Caecilia Tech>');
     writelnbuff('<!-- http://langitbiru.hypermart.net>');
     writelnbuff('<!-- English version by Michael Petrie - Jan 2001>');
     writelnbuff('<!-- http://www.wordstar.org, http://www.petrie.u-net.com>');

     writelnbuff('<TITLE>'+destname+'</TITLE>');
     writelnbuff('</HEAD>'#13#10'<BODY>');
     writelnbuff('');
     c:=' ';
     while ((charidx<fsize) and (c<>#26)) do
           begin
                c:=getchar;
                if not normalHtml(c) then
                case c of
                '<','>',' ',
                '"','&'   :    specialCharHTML(c);
                #$0f      :    specialCharHTML(' ');

                #$1b      :    begin
                                    writebuff(';&#'+num2str(byte(getChar)));
                                    skipbyte(1);
                               end;
                #$0d,#$0a :    begin
                                    if c=#$0d then writebuff('<br>');
                                    putChar(c);
                               end;
                #$8d      :
                               if normal then getchar else
                               begin
                                    putChar(#$0d);
                                    writebuff('<br>');
                               end;
                '.'       :    if lastisret then
                                  handleDotCommandHTML
                               else putchar('.');
                #$1d      :    begin
                                    skip:=getWord;
                                    if not
                                    handleSymmetricCode(getchar,normal)
                                    then
                                    skipbyte(skip-1);
                               end;
                #2,#4,#$13,#$14,
                #$16,#$18,#$19 : handleHTMLstyle(c);
                end;
           end;
    writelnbuff('');
    writelnbuff('</BODY>'#13#10'</HTML>');
end;

{**********************************************************}
{convert to RTF}
procedure specialCharRTF(c:char);
begin
     writebuff('\'+c);
end;

function normalRTF(c :char):boolean;
begin
     normalRTF:=false;
     if pos(c,'{\}')>0 then exit;
     if ((c in [#32..#127]) and (c<>'.')) then
        begin
             normalRTF:=true;
             putchar(c);
        end;
end;

procedure handleRTFstyle(c:char);
const controlInfo =#2#4#$13#$14#$16#$18#$19;
var b:byte;
begin
     b:=pos(c,controlinfo);
     printstate[b]:=not printstate[b];
     if printstate[b] then writebuff('{\'+printTagRTF[b]+' ') else
        writebuff('}'{'\'+printTagRTFC[b]})
end;

procedure handleTabRTF(mode:boolean);
var tabs : tabstruc;
    b    : byte;
begin
     with tabs do
          begin
               tabsizeHMI:=getWord;
               abstabsizeHMI:=getWord;
               tabtype:=byte(getChar);
               tabsize:=byte(getChar);
          end;
     if not mode then
     for b:=1 to tabs.tabsize do
         writebuff(' ');
     skipbyte(3);{skip symetric seq}
end;

procedure handleRTFColor;
var b:byte;
begin
     if ignoreclr then
        begin
             skipbyte(5);
             exit;
        end;
     b:=byte(getChar);
     getChar;
     if b in [0..15] then writebuff('\cf'+num2str(b+1));
     skipbyte(3);
end;


function handleSymmetricCodeRTF(c: char; mode:boolean):boolean;
begin
     handleSymmetricCodeRTF:=false;
     case c of
          #1         : begin
                            handleRTFcolor;
                            handleSymmetricCodeRTF:=true;
                       end;

          #9         : begin
                            handleTabRTF(mode);
                            handleSymmetricCodeRTF:=true;
                       end;
          end;
end;

procedure handleDotCommandRTF;
var s:string;
    c:char;
begin
     s:='';
     c:=getChar;
     s:=s+c;
     while c<>#$0a do
           begin
                c:=getChar;
                if not (c in [#$0a,#$0d]) then s:=s+c;
           end;
     s:=upperCase(s);
     if left(s,2)='OC' then
        if scan(s,'ON') then
           begin
                writebuff('\par\qc');
                justify:=1;
           end
        else if scan(s,'OFF') then
             begin
                  writebuff('\par\ql');
                  justify:=0;
             end;
     if left(s,2)='PA' then writebuff('\page');
     lastisret:=true;
end;

procedure createColorTable;
var i,r,g,b:byte;
    c:integer;
    s:string[6];
begin
     for i:=0 to 14 do
     begin
          s:= colors[i];
          val('$'+left(s,2),r,c);
          delete(s,1,2);
          val('$'+left(s,2),g,c);
          delete(s,1,2);
          val('$'+left(s,2),b,c);
          delete(s,1,2);
          writebuff('\red'+num2str(r)+'\green'+num2str(g));
          writelnbuff('\blue'+num2str(b)+';');
     end;

end;

procedure createRTFHeader;
begin
     writelnbuff('{\rtf1\ansi\ansicpg1252\deff0\deflang1057{\fonttbl ');
     {font definition}
     writelnbuff('{\f0\fnil\fcharset0 Times New Roman;}');
     writelnbuff('{\f1\fswiss\fprq2\fcharset0 Arial;}');
     writelnbuff('{\f2\froman\fcharset0 Times New Roman;}');
     writelnbuff('}');
     {colour table}
     writelnbuff('{\colortbl ;');
     if not ignoreclr then createColorTable;
     writelnbuff('}');
     writelnbuff('\deff0');
     writelnbuff('\pard');
end;

procedure createRTFTrailer;
begin
     writelnbuff('\par }');
end;

procedure crRTF;
begin
     case justify of
          0 : writebuff('\par\qj');
          1 : writebuff('\par\qc');
          2 : writebuff('\par\qr');
     end;
end;

procedure convertToRTF(normal:boolean);
var c:char;
    skip:word;
begin
     c:=' ';
     {create RTF header}
     createRTFHeader;
     while ((charidx<fsize) and (c<>#26)) do
           begin
                c:=getchar;
                if not normalRTF(c) then
                case c of
                '}','\','{'
                          :    specialCharRTF(c);

                #$1b      :    begin
                                    writebuff('\'''+b2hex(byte(getChar)));
                                    skipbyte(1);
                               end;
                #$0d,#$0a :    begin
                                    if c=#$0d then crRTF;
                                    putChar(c);
                               end;
                #$8d      :
                               if normal then getchar else
                               begin
                                  putChar(#$0d);
                                  crRTF;
                               end;
                '.'       :    if lastisret then
                                  handleDotCommandRTF
                               else putchar('.');
                #$1d      :    begin
                               skip:=getWord;
                               if not handleSymmetricCodeRTF(getchar,normal)
                               then
                               skipbyte(skip-1);
                               end;
                #2,#4,#$13,#$14,
                #$16,#$18,#$19 : handleRTFstyle(c);
                end;
           end;
     createRTFTrailer;
end;

{*********************************************************}
procedure about(help:boolean);
const title : array [0..17] of string[70] =
      ('  WS-CON 1.01 : File Converter from WS to TXT, HTML and RTF',
       '  (c) Mei 1999 Yohanes Nugroho. Caecilia Tech.',
       '  e-mail    : yohanes@biosys.net, yohanes_n@hotmail.com',
       '  web site  : http://langitbiru.hypermart.net'#13#10,
       '  English version: (c) 2001 Mike Petrie, United Kingdom',
       '  http://www.petrie.u-net.com, http://www.wordstar.org'#13#10,
       '  usage :  ws-con file_ws file_out [options]'#13#10,
       '  the program will automatically choose the output file',
       '  type based on the file extension given in file_out. If the',
       '  required type cannot be determined it will default to text'#13#10,
       '  options :'#13#10,
       '  /T      :    force conversion to TXT',
       '  /H      :    force conversion to HTML',
       '  /R,/D   :    force conversion to RTF (DOC)',
       '  /U      :    use un*x text format (LF only, not CRLF)',
       '  /W      :    process colours based on WS document',
       '  /S      :    convert tables to lines for HTML/RTF',
       '  /?      :    display this help screen'
       );

var b,c : byte;
begin
     writeln(so);
     if help then c:=16 else c:=3;
     for b:=0 to c do writeln(so,title[b]);
     if not help then writeln(so);
     if help then
        begin
             close(so);
             close(si);
             halt(0);
        end;
end;


procedure determineDestType;
var s:string;
    b:byte;
begin
     desttype:=0;
     b:=pos('.',destname);
     if ((b=0) or (b=length(destname))) then desttype:=0  {text (Default)}
     else
     begin
          s:=copy(destname,b+1,3);
          if s='HTM' then desttype:=1;
          if ((s='DOC') or (s='RTF')) then desttype:=2;
     end;

end;

procedure scanParam;
var b:byte;
    dstselect:boolean;
    s:string;
begin
     dstselect:=false;
     for b:=3 to paramcount do
     begin
          s:=uppercase(paramstr(b));
          if s='/?' then about(true);
          if s='/S' then modesr:=false;
          if s='/W' then ignoreclr:=false;
          if s='/U' then unixtext:=true;

          if ((s='/T') or (s='/H') or (s='/R') or (s='/D')) then
          begin
               if dstselect then exitError(msg_desttypeerr,4);
               dstselect:=true;
               case s[2] of
                    'T'       : desttype:=0;
                    'H'       : desttype:=1;
                    'R','D'   : desttype:=2;
               end;
          end;
     end;
end;

procedure startConvert;
begin
     writeln(so);
     writeln(so,'   converting ',srcname,' to ',destname);
     writeln(so,'   from WS format to ',dsttype[desttype]);
end;
{**********************************************************}
{START OF PROGRAM}

begin
     assign(so,'');
     rewrite(so);
     assign(si,'');
     reset(si);
     desttype:=-1;
     modesr:=true;
     ignoreclr:=true;
     unixtext:=false;
     if (paramcount<2) then  about(true);
     about(false);
     srcname:=uppercase(paramstr(1));
     destname:=uppercase(paramstr(2));
     if paramcount>2 then scanParam;
     if (not fileexists(srcname)) then
        exitError(msg_filenotfound+srcname,1);
     if srcname=destname then exitError(msg_destnameerr,2);
     if fileexists(destname) then
        if (not ask(msg_destexist)) then
           exitError(msg_canceled,3);
     if desttype=-1 then determineDestType;
     startConvert;
     openFile(srcname,destname);
     initData;
     if readheader then readWsHeader;
     printHeaderInfo;
     case desttype of
          0 :      convertToText;
          1 :      convertTOHTML(modesr);
          2 :      convertToRTF(modesr);
     end;
     flushOutput;
     closefiles;
     freeMemory;
     writeln(so);
     writeln(so,'  conversion summary');
     writeln(so,'  data read ',formatnumber(charidx),' bytes');
     writeln(so,'  data written ',formatnumber(outcharidx),' bytes');
     writeln(so);
     close(so);
     close(si);
end.
