}  pPCL                                                                                                                   } Symmetrical Sequences

0    Header
1    Color
2    Font
3    Footnote
4    Endnote
5    Annotation
6    Comment
7    Reserved
8    Reserved
9    Tabs and dot leaders
A    Reserved
B    End of page
C    Page Offset
D    Paragraph number
E    Index item
F    User print control
10   Graphics insert
11   Paragraph style
12   Reserved
13   Reserved
14   Reserved
15   Alternate/Normal font change
16   Truncation
17on Reserved
.pa  5   3                     
.lha
.mb3
.op
.oj off
.oc on
.fo
 	2
2
!
  r  Ĵ  D WordStar 7.0 File Format      Page #

 	\
\

    Ĵ  F WordStar International Incorporated


 	7
7

 File Format for WordStar Release 7.0


 	
 March 17, 1992   F   
.oc off


The WordStar file format is a living specification, continually 
evolving to meet the needs of new provisions and features.  With 
each release of WordStar, new commands are established, and 
slight changes are made to the meaning of various codes.  While 
every effort has been made to make this document an accurate 
reflection of the WordStar format as it stands now, no guarantee 
can be given that future releases of the program will follow the 
specifications as they are expressed here.  


Textual Information 

WordStar files contain text which conforms in general to the 7-
bit ASCII code for printable characters.  All codes below 20h are 
reserved for control information, and the high (8th) bit on 
characters is likewise used to convey information about 
formatting and document control.  A raw stream of the printable 
text in a WordStar file could therefore be discerned by masking 
off the 8th bit and discarding codes in the range of 
00hthrough1Fh.   This method would, of course, omit all 
formatting and control information in the file.  In addition to 
stripping control characters, symmetrical sequences must be 
stripped.  See the description of symmetrical sequences below.

More recent versions of WordStar (release 3.4 and above) provide 
for an extension to the 7-bit ASCII character set by means of 3-
byte sequences.  These codes all begin with the lead-in character 
<1Bh> and end with the trailer <1Ch>.  The code in between these 
two characters can be any value in the range from 
00hthroughFFh.  In general, this scheme is used to support 
printable codes less than 20h and greater than 7Fh.

Starting with version 5.0, WordStar files also contain 
"Symmetrical Sequences".  These are used for footnotes, font 
tags, etc.  In addition, WordStar 5.0 (and later) files begin 
with a symmetrical sequence which is used as a header.  See the 
description of the header symmetrical sequence below.


Formatting and Control Information 
  0   3                    
  0   3                    
High Bits 

All WordStar files terminate normal lines (paragraphs) with the 
sequence <0Dh,0Ah> (carriage return, line feed).  A "soft 
return" <8Dh,0Ah> is inserted in the text stream at the points 
where lines are subject to word-wrap.  A "soft space" <A0h> is 
inserted for tabbing, justification, and for left-margin 
indentation.  In normal mid-paragraph lines, the blank characters 
(usually space) following words at the end of lines will be 
retained, so that the user's text is fully retained.

An "inactive soft hyphen" <1Eh> is inserted in the text stream at 
places where hyphenation may be allowed to occur.  When the word 
is actually broken at the hyphenation spot, the inactive soft 
hyphen is changed to an "active soft hyphen" <1Fh>.  This active 
hyphen, since it falls at the end of a mid-paragraph line, will 
be immediately followed by the soft return mentioned above.

In versions of WordStar prior to 5.0, the high bit was set on the 
last character of all non-blank text strings that fell within the 
margins.  The printer drivers relied on this information to de
termine which text was to be microjustified.  This functionality 
was dropped in the later versions in favor of the use of absolute 
tabs, margin dot commands, and paragraph styles.


Low-order Codes 

WordStar (all versions) uses the ASCII codes below 20h for 
control information.  The specific assignment of meanings to 
codes is as follows:

.rr                      L--------------------------------------R
.pm11

 	

 00h ^@
 	T 	
 Fix the print position.  At print time 

 	
 the print head is moved to the absolute 

 	
 column position where the ^@ appears in 

 	
 the text.  This is primarily used to 

 	
 line up proportional text or text that 

 	
 mixes the normal and alternate character 

 	
 widths.


 	

 01h ^A
 	T 	
 Alternate font.  At print time the 

 	
 alternate character width is selected at 

 	
 the point in the text where the ^A 

 	
 appears.  The alternate character width 

 	
 can be either preinstalled or changed 

 	
 with the .cw dot command while ^A is in 

 	
 effect.  This print control is now 

 	
 obsolete.  See the description of   0   e6                     
 	
 symmetrical sequence 15h, below.


 	

 02h ^B
 	T 	
 Boldface type ON/OFF toggle.


 	

 03h ^C
 	T 	
 Pause for user response during print.


 	

 04h ^D
 	T 	
 Double strike printing ON/OFF toggle.


 	

 05h ^E
 	T 	
 Custom print control.  The user may 

 	
 either preinstall the print control 

 	
 string to be sent when ^E is encountered 

 	
 in the text, or the .xe dot command may 

 	
 be used to define it within a document.


 	

 06h ^F
 	T 	
 Phantom space.  Primarily used to access 

 	
 characters on a daisy wheel at the 20h 

 	
 print position.  On other types of 

 	
 printers results vary.


 	

 07h ^G
 	T 	
 Phantom rubout.  Primarily used to 

 	
 access characters on a daisy wheel at 

 	
 the 7Fh print position.  On other types 

 	
 of printers results vary.

 	

 

 	

 08h ^H
 	T 	
 Overprint previous character.


 	

 09h ^I
 	T 	
 Tab character.  At print time the number 

 	
 of hard spaces required to reach a 

 	
 modulus 8 print position is generated.


 	

 0Ah ^J
 	T 	
 Line feed.  At print time causes a paper 

 	
 advance to the next line.

.. said "it is used to around" but corrected by RJS on Saturday, March 28, 2015
.. said "odd numbered" but corrected by RJS on Saturday, March 28, 2015

 	

 0Bh ^K
 	T 	
 Within the main text body, it is used 

 	
 around words or phrases to be indexed.  

 	
 In a header or footer line, on even 

 	
 numbered pages all blanks following the 

 	
 ^K are suppressed.


 	

 0Ch ^L
 	T 	
 Form Feed.  At print time causes page to 

 	
 be ejected.  No footer lines are 

 	
 printed.


 	

 0Dh ^M
 	T 	
 Carriage return.


 	

 0Eh ^N
 	T 	
 Return to the normal character width.  

 	
 Now obsolete, see the description for 

 	
 the symmetrical sequence 15h, below.  0   e6                    
  0   e6                    

 	

 0Fh ^O
 	T 	
 Binding space.  Printed as a space.  It 

 	
 is used to bind together text that must 

 	
 not be split when a paragraph is 

 	
 realigned.


 	

 10h ^P
 	T 	
 Reserved.


 	

 11h ^Q
 	T 	
 Custom print control.


 	

 12h ^R
 	T 	
 Custom print control.


 	

 13h ^S
 	T 	
 Underline ON/OFF toggle.


 	

 14h ^T
 	T 	
 Superscript ON/OFF toggle.


 	

 15h ^U
 	T 	
 Reserved.


 	

 16h ^V
 	T 	
 Subscript ON/OFF toggle.


 	

 17h ^W
 	T 	
 Custom print control.


 	

 18h ^X
 	T 	
 Strikeout ON/OFF toggle.  Causes all 

 	
 text between successive ^X's to be 

 	
 overstruck with a dash (unless re-

 	
 installed for some other character).


 	

 19h ^Y
 	T 	
 Italics ON/OFF toggle (depending on the 

 	
 printer).  Versions of WordStar prior to 

 	
 5.0 could also use this character as a 

 	
 ribbon color change.  This was replaced 

 	
 in the later versions with color 

 	
 selection via ^P-.


 	

 1Ah ^Z
 	T 	
 End of file character.  When encountered 

 	
 indicates the end of the file.


 	

 1Bh ^[
 	T 	
 Escape.  Reserved.  Also used as the ex

 	
 tended character set lead-in code.  If 

 	
 the second byte following the 1Bh is a 

 	
 1Ch, the intervening byte is an extended 

 	
 character.  Example: <1Bh,AEh,1Ch>.


 	

 1Ch ^\
 	T 	
 Reserved.  Also used as the extended 

 	
 character set trailer code if the second 

 	
 byte preceding it is a 1Bh.


 	

 1Dh ^]
 	T 	
 Symmetrical sequence start/stop 

 	
 character (see below).  0   e6                    
  0   e6                    

 	

 1Eh ^^
 	T 	
 Inactive soft hyphen.  Indicates a 

 	
 position at which a word may be broken 

 	
 for word-wrap.


 	

 1Fh ^_
 	T 	
 Active soft hyphen.  Indicates a place 

 	
 at which a word has been broken for 

 	
 word-wrap.

.RR--!----!----!----!----!----!----!----!----!----!----!--------R
Dot Commands

Additional formatting information is recorded in WordStar files 
through means of "dot commands."  Dot commands are instructions 
that are preceded (in the first position in the line) by a period 
<2Eh> and stand alone as the only entry on that line.  (See the 
WordStar documentation for exact descriptions of each dot 
command.)

In the table below, the codes in the "Usage" column indicate the 
following:


 	 
 M
 	 
 Affects only merge printing.

 	 
 I
 	 
 Affects only indexing.

 	 
 T
 	 
 Affects only table of contents.

 	 
 P
 	 
 Affects printing or merge printing.

 	 
 E
 	 
 Affects editing, printing, or merge printing.

In most cases, the dot commands that affect editing show some 
effect on the screen as the command is typed or changed.  As the 
cursor is moved forward through the document, WordStar stores 
enough information about the command so that the previous state 
can be restored when the cursor is later moved backwards.  There 
is a limited amount of storage for this information and it is 
controlled with the User Area variable DSTKSZ.

Versions prior to 4.0 require whole numbers as arguments to dot 
commands that require numbers (subscript roll, page offset).  
With version 4.0, math was allowed in the arguments for easier 
entry of complex page layouts.  In version 5.0, the ability to 
specify measurements in inches was added.  In version 5.5 
revision C, measurements in points and centimeters were allowed.  
Inches in 5.0 were specified using the double quote only.  In 
5.5C, inch measurements were allowed with 'I' or 'IN'.  
Centimeters are specified as 'C' or 'CM', and points with 'P' or 
'PM'.  Upper and lower case are allowed with these.  Most dot 
commands that take their arguments as number of lines or columns 
will allow measurements as well.  Refer to the WordStar 
documentation to find out which dot commands accept measurements 
as arguments.   0   e6                    


  0   e6                    
The present interpretation of dot commands is:

.cp3
.rr                      L--!---!-------------------------------R
.pm9
.tb 19,26,29,33

 	
 Command  Usage   Meaning


 	
 .AV
 	 
 M
 	8 
 Ask for variable.  Requests the user to  

 	
 enter data from the keyboard at print 

 	
 time for a specific variable.


 	
 .AW
 	 
 E M
 	 
 Aligning and word wrap ON/OFF.  Enables 

 	
 or disables aligning and word wrap at a 

 	
 specific point in the document.  Used 

 	
 primarily to prevent changes to tables.


 	
 .BN
 	 
 P
 	8 
 Bin select.  Selects one of the sheet

 	
                  feeder bins at print time. The number 

 	
                  of sheet feeders is defined in the

 	
                  PDF.


 	
 .BP
 	 
 P
 	8 
 Bidirectional print ON/OFF.  Enables and 

 	
 disables bidirectional printing.  If the 

 	
 printer does not have bidirectional 

 	
 printing capability, this command is 

 	
 ignored.


 	
 .CC
 	 
 E P
 	 
 Conditional column break.  Like the .CP 

 	
 command, but works with columnar breaks 

 	
 instead.  If the number of lines 

 	
 following the conditional column break 

 	
 command fit on the current page, then 

 	
 there is no effect, otherwise, a 

 	
 columnar break will occur.


 	
 .CO
 	 
 E P
 	 
 Columns.  Allows the user to specify the 

 	
 number of columns and optionally, the 

 	
 gutter width in columns or inches.


 	
 .CP
 	 
 E P
 	 
 Conditional page break.  If there are 

 	
 less than the number of lines specified 

 	
 remaining on the page, then a page break 

 	
 is generated.  If the number of lines 

 	
 following the conditional page break fit 

 	
 on the current page, then there is no 

 	
 effect.  Takes the line height changes 

 	
 into account.


 	
 .CS
 	 
 P
 	8 
 Clear screen and display message.  This 

 	
 command is used to clear the screen 

 	
 during printing.  If a message follows   0   e6                     
 	
 the .CS, it is displayed on the first 

 	
 screen line below the Print Menu.


 	
 .CV
 	 
 E P
 	 
 Convert note type.  For further areas in 

 	
 the document, all notes of the first 

 	
 type specified will be treated as notes 

 	
 of the second type.  Works with 

 	
 comments, footnotes, and endnotes.


 	
 .CW
 	 
 P
 	8 
 Character width.  This command allows 

 	
 the user to specify the width of the 

 	
 characters in 1/120 inch increments.  

 	
 This width takes effect on the next line 

 	
 of text.  Either the normal (^N) or  

 	
 alternate (^A) character width is 

 	
 changed depending which is in effect.  

 	
 The default is 12 (12/120ths is 10 

 	
 characters per inch).


 	
 .DF
 	 
 M
 	8 
 Data file.  This merge print command is 

 	
 used to specify the file name which 

 	
 holds data that will be merged into 

 	
 text.  The data file may be in comma 

 	
 delimited format, a dBASE file, or a 

 	
 Lotus 123, Symphony, Quattro, or VP- 

 	
 Planner worksheet.  The user may also 

 	
 optionally change the data separator 

 	
 character for that file.


 	
 .DM
 	 
 P
 	8 
 Display a message. Displays a message on 

 	
 the screen at print time.  If printing 

 	
 in the background, .DM's can "scroll 

 	
 off" the screen while it is hidden from 

 	
 the user.


 	
 .E#
 	 
 E P
 	 
 Set endnote value.  Specifies the new 

 	
 value for endnote numbering.


 	
 .EI
 	 
 M
 	8 
 End if.  Indicates the final spot in a 

 	
 merge print document affected by a .IF 

 	
 command.  There must be one .EI for 

 	
 every .IF command.


 	
 .EL
 	 
 M
 	8 
 Else.  Used for the "else" case after 

 	
 using a .IF command.  .EL commands are 

 	
 optional.


 	
 .F#
 	 
 E P
 	 
 Set footnote numbering type and value.    0   e6                     
 	
 Specifies the new value for footnote 

 	
 numbering.  Optionally specifies whether 

 	
 footnote numbering should restart every 

 	
 page or be consecutive throughout the 

 	
 document.


 	
 .FI
 	 
 P
 	8 
 File insert.  Prints the specified file 

 	
 at that point in the document.  .FI 

 	
 commands may be nested up to 7 levels 

 	
 deep.  .FI files can be in ASCII, 

 	
 WordStar, or Lotus 123, Symphony, 

 	
 Quattro, or VP-Planner worksheets.


 	
 .FM
 	 
 P
 	8 
 Footer margin.  The number of blank 

 	
 lines from the end of the text on a page 

 	
 to the first footer line.  Default is 2.  

 	
 The sum of the footer margin plus the 

 	
 number of footer lines must be less than 

 	
 or equal to the bottom margin. 


 	
 .FO or F1
 	  
 P
 	8 
 Footer.  The text following the 

 	
 command .F1 will be printed as the first 

 	
 footer line on this and all subsequent 

 	
 pages.  A .FO (or .F1) followed by one 

 	
 or zero blanks cancels the footer line.  

 	
 The footer uses the character width and 

 	
 line height in effect at the time 

 	
 the .FO (or .F1) command is encountered 

 	
 in the text.  .FO can optionally specify 

 	
 even or odd numbered page footers.


 	
 .F2
 	 
 P
 	8 
 Second footer.


 	
 .F3
 	 
 P
 	8 
 Third footer.


 	
 .F4
 	 
 P
 	8 
 Fourth footer.


 	
 .F5
 	 
 P
 	8 
 Fifth footer.


 	
 .GO
 	 
 P
 	8 
 Go to top or bottom of document.


 	
 .HE or H1
 	  
 P
 	8 
 Header.  The text following the 

 	
 command .H1 is printed as the first 

 	
 header line on all subsequent pages.  If 

 	
 the header command is one of the first 

 	
 dot commands on a page it takes effect 

 	
 for that page, otherwise it affects the 

 	
 following pages.  A .HE or .H1 followed   0   e6                     
 	
 by one or zero blanks cancels the header 

 	
 line.  The header uses the character 

 	
 width and line height in effect at the 

 	
 time the .HE or .H1 command is 

 	
 encountered in the text.  .HE can 

 	
 optionally specify even or odd numbered 

 	
 page headers.


 	
 .H2
 	 
 P
 	8 
 Second header.


 	
 .H3
 	 
 P
 	8 
 Third header.


 	
 .H4
 	 
 P
 	8 
 Fourth header.


 	
 .H5
 	 
 P
 	8 
 Fifth header.


 	
 .HM
 	 
 P
 	8 
 Header margin.  The number of blanks 

 	
 lines between the top of the text on a 

 	
 page and the last header line.  Default 

 	
 is 2.  The sum of the header margin plus 

 	
 the number of header lines must be less 

 	
 than or equal to the top margin.


 	
 .HY
 	 
 E P
 	 
 Turn Auto-Hyphenation ON/OFF.  Enables 

 	
 or disables the hyphenator.  Starting 

 	
 with WordStar 6.0 Rev. D.


 	
 .IF
 	 
 M
 	8 
 If.  Used for conditional merge printing 

 	
 in conjunction with the .EL and .EI 

 	
 commands.  Only simple conditions can be 

 	
 tested using the following operators:


 	
 
 	 

 
 	 
 
 	 
 =   Strings alphabetically equal.

 	
 
 	 

 
 	 
 
 	 
 <>  Strings unequal.

 	
 
 	 

 
 	 
 
 	 
 >   Greater than.

 	
 
 	 

 
 	 
 
 	 
 <   Less than.

 	
 
 	 

 
 	 
 
 	 
 #=  Numbers equal.

 	
 
 	 

 
 	 
 
 	 
 #<> Numbers unequal.

 	
 
 	 

 
 	 
 
 	 
 #>  Greater than.

 	
 
 	 

 
 	 
 
 	 
 #<  Less than.


 	
 
 	 

 
 	 
 .IF commands may be nested up to 255 

 	
 levels deep.


 	
 .IG or..
 	h 
 E
 	8 
 Ignore.  The text on the remainder of .. 

 	
 the line is treated as an unprinted 

 	
 comment.
  0   e6                     

 	
 .IX
 	 
 I
 	8 
 Index.  The text on the remainder of the 

 	
 line is put in the index.  A comma is 

 	
 used to separate a main index entry from 

 	
 a subentry.  If a dash is the first 

 	
 character following the .IX, the index 

 	
 entry is treated as a cross reference 

 	
 entry.  If a plus sign is the first 

 	
 character following the .IX, the page 

 	
 number for that index entry is printed 

 	
 in boldface.


 	
 .KR
 	 
 P
 	8 
 Kerning.  Adjusts space between certain 

 	
 pairs of printed characters for fonts 

 	
 that contain kerning information.


 	
 .L#
 	 
 P
 	8 
 Line numbering.  Specifies whether to 

 	
 turn line numbering off, or the spacing 

 	
 and position of the line numbering.  

 	
 Also optional is whether to start 

 	
 numbering at the beginning of each page 

 	
 or the beginning of the document.


 	
 .LH
 	 
 E P
 	 
 Line height.  Changes current line 

 	
 height in 1/48 inch increments.  The 

 	
 default is 8/48 or 6 lines per inch.  

 	
 All lines following this command are set 

 	
 based on the current line height value.  

 	
 Optionally, an argument of 'A' or 'a' 

 	
 will turn on "auto-leading", and all 

 	
 subsequent lines will use the line 

 	
 height of the largest font in the line.


 	
 .LM
 	 
 E P
 	 
 Left margin.  Determines the left edge 

 	
 of subsequent text.


 	
 .LQ
 	 
 P
 	8 
 Letter quality ON/OFF.  Enables or 

 	
 disables letter quality printing on dot 

 	
 matrix printers (ignored if not 

 	
 supported on the printer).


 	
 .LS
 	 
 E P
 	 
 Line spacing.  Selects a line spacing of 

 	
 between 1 and 9 for subsequent typing or 

 	
 paragraph alignment.  A value of 1 is 

 	
 for single spacing, 2 for double 

 	
 spacing, etc.


 	
 .MA
 	 
 M
 	8 
 Math.  Stores the results of a complex 

 	
 equation in a variable.  0   e6                    
  0   e6                    

 	
 .MB
 	 
 E P
 	 
 Bottom margin.  The footer or page 

 	
 number is printed within this margin.  

 	
 The default value is 8 lines.


 	
 .MT
 	 
 E P
 	 
 Top margin.  The number of lines from 

 	
 the beginning of the page to the 

 	
 beginning of printed text.  The header 

 	
 is printed within this margin.  Default 

 	
 value is 3 lines.


 	
 .OC
 	 
 E P
 	 
 Centering ON/OFF.  When ON, further 

 	
 lines in the document will be centered 

 	
 within the left and right margins until  

 	
 a .OC OFF command is encountered.


 	
 .OJ
 	 
 E P
 	 
 Output justification ON/OFF.  Command 

 	
 which turns right justification ON or 

 	
 OFF for subsequent typing or paragraph 

 	
 realignment.  When OFF, text is ragged 

 	
 at the right margin.  When ON, text is 

 	
 flush right.


 	
 .OJ
 	 
 C
 	8 
 Center.


 	
 .OJ
 	 
 R
 	8 
 Right flush.


 	
 .OP
 	 
 P
 	8 
 Omit page number.  At print time no page 

 	
 numbers are printed unless the "#" has 

 	
 been used in footers or headers.


 	
 .P#
 	 
 E P
 	 
 Paragraph number.  Specifies the initial 

 	
 value and/or the format to use for 

 	
 paragraph numbering.  Also optionally 

 	
 specifies whether compound or outline 

 	
 numbering is to be used.


 	
 .PA
 	 
 E P
 	 
 Page break.  Begin a new page here.


 	
 .PC
 	 
 P
 	8 
 Page column. Indicates the column at 

 	
 which the page number will be printed.  

 	
 This is active only when the footers are 

 	
 not in use and page numbering is turned 

 	
 on.  If the column specified is 0, then 

 	
 the page number is centered between the 

 	
 margins in effect where the .PC command 

 	
 is given.


 	
 .PE
 	 
 P
 	8 
 Print endnotes.  When encountered during   0   e6                     
 	
 printing, endnotes will be printed at 

 	
 this point in the document.


 	
 .PF
 	 
 P
 	8 
 Paragraph realignment while printing.  

 	
 May be ON, OFF, or DIS (for 

 	
 discretionary).  When ON, subsequent 

 	
 paragraphs are realigned as they are 

 	
 printed.  When OFF, paragraphs are not 

 	
 realigned.  When DIS, paragraphs are 

 	
 realigned only when merge print data is 

 	
 substituted in the document.  Paragraphs 

 	
 are aligned using the left, right, and 

 	
 paragraph margins currently in effect.


 	
 .PG
 	 
 P
 	8 
 Number pages.  At print time the page 

 	
 number is printed at the bottom of the 

 	
 page unless a footer overrides it.  

 	
 Usually used to restore page numbering 

 	
 after being turned off with .OP.


 	
 .PL
 	 
 E P
 	 
 Page length.  The total number of lines 

 	
 in a page assuming 6 lines per inch.  An 

 	
 eleven inch page contains 66 lines.


 	
 .PM
 	 
 E P
 	 
 Paragraph margin.  The left margin to 

 	
 use for the first line of every  

 	
 subsequent paragraph.  Used for both 

 	
 regular and hanging indents.


 	
 .PN
 	 
 E P
 	 
 Page number.  The current page number.


 	
 .PO
 	 
 P
 	8 
 Page offset.  The number of print 

 	
 columns from the left edge of the paper 

 	
 to the left margin of text.  The current 

 	
 setting of character width (.CW) 

 	
 determines the actual amount of 

 	
 indentation.  .PO can optionally specify 

 	
 even or odd number page offsets.


 	
 .PR
 	 
 P
 	8 
 Printer information.  Currently used to 

 	
 select the print orientation for laser 

 	
 printers (use .PR OR=L for landscape, 

 	
 and .PR OR=P for portrait).


 	
 .PS
 	 
 P
 	8 
 Proportional spacing ON/OFF.  Subsequent 

 	
 text is to be printed using a 

 	
 proportional font.
  0   e6                     

 	
 .RM
 	 
 E P
 	 
 Right margin.  Determines the right edge 

 	
 of subsequent paragraphs.


 	
 .RP
 	 
 M
 	8 
 Repeat.  Command to repetitively print 

 	
 copies of a document.  The .DF command 

 	
 may interfere with the .RP command.


 	
 .RR
 	 
 E P
 	 
 Ruler.  Embeds a ruler line to be used 

 	
 for subsequent typing and alignment.  

 	
 The text following the .RR is the exact 

 	
 image of the ruler line above the text 

 	
 on the screen.  A .RR with a # (0-9) 

 	
 specifies a preformatted ruler line 

 	
 (stored in the user area).


 	
 .RV
 	 
 M
 	8 
 Read variable.  Merge print command used 

 	
 to read one or more of the next data 

 	
 from a file into variables.


 	
 .SB
 	 
 E P
 	 
 Suppress blank lines on/off.  Starting 

 	
 with WordStar 6.0 Rev. D, soft lines at 

 	
 the beginning of pages will be 

 	
 automatically suppressed.  This dot 

 	
 command controls the display and 

 	
 printing of blank hard returns at the 

 	
 beginning of pages.


 	
 .SR
 	 
 P
 	8 
 Sub/superscript roll.  The increments 

 	
 (in 1/48ths of an inch) which the 

 	
 carriage is to roll up or down for sub

 	
 script and superscript printing.  

 	
 Default is 3 (3/48ths of an inch).


 	
 .SV
 	 
 M
 	8 
 Set variable.  Merge print command used 

 	
 to store data in a variable.


 	
 .TB
 	 
 E P
 	 
 Tab stops.  Sets multiple tab stops for 

 	
 further editing/printing in the 

 	
 document.


 	
 .TC
 	 
 T
 	8 
 Table of contents.  The text following  

 	
 the .TC is a table of contents entry.  A 

 	
 "#" indicates where the page number is 

 	
 to go in the entry.  .TC1 through .TC9 

 	
 are used to simultaneously build nine 

 	
 other tables.


 	
 .UJ
 	 
 P
 	8 
 Micro justify.  Specifies whether   0   e6                     
 	
 subsequent lines are to be micro- 

 	
 justified at print time.  When ON, the 

 	
 white space necessary to right justify a 

 	
 line is spread in very fine increments 

 	
 evenly over the line.  When OFF, whole 

 	
 blanks are used to spread the white 

 	
 space.  When DIS, the printer driver 

 	
 decides; microjustification is not 

 	
 performed if it slows down printing 

 	
 dramatically.


 	
 .UL
 	 
 P
 	8 
 Continuous underlining ON/OFF.  Enables 

 	
 or disables underlining of blanks 

 	
 between words.


 	
 .XE .XQ
 	 
 P
 	8 
 Custom  print  control.  The  hex  pairs

 	
 .XR .XW
 	 
 
 	 
 following the dot command define the 

 	
 custom print control for ^E, ^Q, ^R, and 

 	
 ^W encountered in the text respectively.  

 	
 The definition may include up to five 

 	
 bytes.


 	
 .XL
 	 
 P
 	8 
 Form feed.  The hex pairs following .XL 

 	
 define the print control string to be 

 	
 sent to eject the paper to the following 

 	
 page when printing.


 	
 .XX
 	 
 P
 	8 
 Strikeout character.  Redefines the 

 	
 character used for strikeouts.

.RR--!----!----!----!----!----!----!----!----!----!----!--------R
Symmetrical Sequences

Symmetrical sequences are used for features that cannot be 
handled by dot commands or print control characters, or that 
belong embedded in the text instead of in dot commands.  All sym
metrical sequences begin with the control character 1DH, followed 
by a count (2 bytes), and a type byte.  Symmetrical sequences end 
with a count (2 bytes), and the control character 1DH.  The count 
is stored low order byte first and is the sum of all the 
characters in the symmetrical sequence minus 3 (Thus the count 
can be added to the start address of the sequence to point to the 
end count).  Symmetrical sequences can contain any character 
including 1AH.

Note that some symmetrical sequences can contain symmetrical 
sequences themselves (Annotations, for example).  Currently only 
one level of this recursion is used.
  0   e6                     
Also note that all of these sequences are subject to change.

The present interpretation of symmetrical sequences is:

.cp3
.rr                      !--L---!-------------------------------R
.tb 26,29,33
.pm11


 	

 Header sequence


 	

 Type:     


 	

 0
 		 
 Header:

 	

 
 	
 
 
 	 
 Byte: version number in BCD (50h for 

 	
 Release 5.0, 55h for Release 5.5, 60h 

 	
 for Release 6.0)

 	

 
 	
 
 
 	 
 9 bytes: Null terminated driver name 

 	
 for this document.

 	

 
 	
 
 
 	 
 2 bytes: reserved.

 	

 
 	
 
 
 	 
 2 words: 32-bit pointer to the 

 	
 beginning of the file's style library 

 	
 (lo word in lo,hi format, high word 

 	
 in lo,hi format).

 	

 
 	
 
 
 	 
 107 bytes: Reserved. (Total 128 bytes 

 	
 for header sequence including counts 

 	
 and leading/trailing 1DH).


 	

 Print Controls


 	

 1
 		 
 Color:

 	

 
 	
 
 
 	 
 Byte: Color number (see below).

 	

 
 	
 
 
 	 
 Byte: Previous color in file.

 	

 
 	
 
 
 	 
 The color number is as follows:

 	

 
 	
 
 
 	 
 0 - Black

 	

 
 	
 
 
 	 
 1 - Blue

 	

 
 	
 
 
 	 
 2 - Green

 	

 
 	
 
 
 	 
 3 - Cyan

 	

 
 	
 
 
 	 
 4 - Red

 	

 
 	
 
 
 	 
 5 - Magenta

 	

 
 	
 
 
 	 
 6 - Brown

 	

 
 	
 
 
 	 
 7 - Light Grey

 	

 
 	
 
 
 	 
 8 - Dark Grey

 	

 
 	
 
 
 	 
 9 - Light Blue

 	

 
 	
 
 
 	 
 0AH - Light Green

 	

 
 	
 
 
 	 
 0BH - Light Cyan

 	

 
 	
 
 
 	 
 0CH - Light Red

 	

 
 	
 
 
 	 
 0DH - Light Magenta

 	

 
 	
 
 
 	 
 0EH - Yellow

 	

 
 	
 
 
 	 
 0FH - White on black


 	

 2
 		 
 Font:  0   e6                     

 	

 
 	
 
 
 	 
 Word: Font width in HMIs (1/1800ths)

 	

 
 	
 
 
 	 
 Word: Font height in VMIs (1/1440ths)

 	

 
 	
 
 
 	 
 Word: Typestyle (see below)

 	

 
 	
 
 
 	 
 Word: Previous font width

 	

 
 	
 
 
 	 
 Word: Previous font height

 	

 
 	
 
 
 	 
 Word: Previous typestyle


 	

 
 	
 
 
 	 
 Please note that the typestyle 

 	
 definitions listed below are partial 

 	
 (more are being added) and may 

 	
 change.


 	

 
 	
 
 
 	 
 Typestyles are defined by a word with 

 	
 the high order seven bits defined as 

 	
 follows:


.pm 25

 	
 Bit #:
 	h 
 Usage:


 	
 
 	  
 15
 	  
 
 	 
 Proportional flag

 	
 
 	  
 14
 	  
 
 	 
 Letter quality flag

 	
 
 	  
 13
 	  
 
 	 
 Symbol mapping high bit

 	
 
 	  
 12
 	  
 
 	 
 Symbol mapping low bit
.pm 33

 	 
 00 = Code page 437

 	 
 01 = Code page 850

 	 
 10 = Math

 	 
 11 = Symbols
.pm 25


 	
 
 	  
 11
 	  
 
 	 
 Generic style, high bit

 	
 
 	  
 10
 	  
 
 	 
 Generic style, low bit
.pm 33

 	 
 00 = Sans serif font

 	 
 01 = Serif font

 	 
 10 = Script font

 	 
 11 = Display font
.pm 25
.lm 33

 	
 
 	  
 9
 	h 
 
 	 
 Set to 1 to indicate that this 

 	 
 font symmetrical sequence is 

 	 
 different from previous versions.  

 	 
 Previous versions had this bit 

 	 
 set to 0.
.pm 26
.lm 26

 	
 The low order nine bits (8 through 0) 

 	
 contain the typestyle number (which 

 	
 corresponds to a named typestyle). When 

 	
 a typestyle appears in a font 

 	
 symmetrical sequence that does not match 

 	
 the printer selected, a best guess is 

 	
 made for the closest font that will 

 	
 match.
  0   e6                    
  0   e6                    
.pm 26
.lm 28


 	
 0 LinePrinter

 	
 1 Pica

 	
 2 Elite

 	
 3 Courier

 	
 4 Helv (also Helvetica, CG Triumvirate, 

 	
 and Swiss)

 	
 5 Tms Rmn (also CG Times, Times Roman 

 	
 and Dutch)

 	
 6 Gothic (see also 130 Letter Gothic)

 	
 7 Script

 	
 8 Prestige (see also 48 Prestige Elite)

 	
 9 Caslon
.lm 29

 	
 10 Orator

 	
 11 Presentations

 	
 12 Helv Cond. (also Swiss Condensed)

 	
 13 Serifa

 	
 14 Blippo

 	
 15 Windsor

 	
 16 Century (also see #23)

 	
 17 ZapfHumanist

 	
 18 Garamond

 	
 19 Cooper

 	
 20 Coronet

 	
 21 Broadway

 	
 22 Bodoni 

 	
 23 Cntry Schlbk (also see #16)

 	
 24 Univ. Roman

 	
 25 Helv Outline

 	
 26 Peignot (also Exotic)

 	
 27 Clarendon

 	
 28 Stick

 	
 29 HP-GL Drafting

 	
 30 HP-GL Spline

 	
 31 Times

 	
 32 HPLJ Soft Font

 	
 33 Borders

 	
 34 Uncle Sam Open

 	
 35 Raphael

 	
 36 Uncial

 	
 37 Manhattan

 	
 38 Dom Casual

 	
 39 Old English

 	
 40 Trium Condensed

 	
 41 Trium UltraComp

 	
 42 Trade ExtraCond

 	
 43 American Classic (also Amerigo)

 	
 44 Globe Gothic Outline  0   e6                     

 	
 45 UniversCondensed (also Zurich Con

 	
 densed)

 	
 46 Univers (also Zurich)

 	
 47 TmsRmnCond (Oki Laserline 6)

 	
 48 PrstElite (see also 8 Prestige)

 	
 49 Optima

 	
 50 Aachen (Postscript)

 	
 51 AmTypewriter

 	
 52 Avant Garde

 	
 53 Benguiat

 	
 54 Brush Script

 	
 55 Carta

 	
 56 Centennial

 	
 57 Cheltenham

 	
 58 FranklinGothic

 	
 59 FrstyleScrpt

 	
 60 FrizQuadrata

 	
 61 Futura

 	
 62 Galliard

 	
 63 Glypha

 	
 64 Goudy

 	
 65 Hobo

 	
 66 LubalinGraph

 	
 67 Lucida

 	
 68 LucidaMath

 	
 69 Machine

 	
 70 Melior (also Zapf Elliptical)

 	
 71 NewBaskrvlle (also Baskerville)

 	
 72 NewCntSchlbk

 	
 73 News Gothic (also Trade Gothic)

 	
 74 Palatino (also Zapf Calligraphic)

 	
 75 Park Avenue

 	
 76 Revue

 	
 77 Sonata

 	
 78 Stencil

 	
 79 Souvenir

 	
 80 TrmpMedievel (also Activa)

 	
 81 ZapfChancery

 	
 82 ZapfDingbats

 	
 83 Stone

 	
 84 CntryOldStyle

 	
 85 Corona

 	
 86 GoudyOldStyle

 	
 87 Excelsior

 	
 88 FuturaCondensed

 	
 89 HelvCompressed

 	
 90 HelvExtraCompressed

 	
 91 Helv Narrow  0   e6                     

 	
 92 HelvUltraCompressed

 	
 93 KorinnaKursiv

 	
 94 Lucida Sans

 	
 95 Memphis

 	
 96 Stone Informal

 	
 97 Stone Sans

 	
 98 Stone Serif

 	
 99 Postscript
.lm 30

 	
 100 NPS Utility

 	
 101 NPS Draft

 	
 102 NPS Corr

 	
 103 NPS SansSer Qual

 	
 104 NPS Serif Qual

 	
 105 PS Utility

 	
 106 PS Draft

 	
 107 PS Corr

 	
 108 PS SansSer Qual

 	
 109 PS Serif Qual

 	
 110 Download

 	
 111 NPS ECS Qual (daisy wheel)

 	
 112 PS Plastic (daisy wheel)

 	
 113 PS Metal (daisy wheel)

 	
 114 CloisterBlack

 	
 115 Gill Sans (also Hammersmith)

 	
 116 Rockwell (also Slate)

 	
 117 Tiffany (ITC)

 	
 118 Clearface

 	
 119 Amelia

 	
 120 HandelGothic

 	
 121 OratorSC (Star et al)

 	
 122 Outline (Toshiba)

 	
 123 Bookman Light (Canon)

 	
 124 Humanist (Canon)

 	
 125 Swiss Narrow (Canon)

 	
 126 ZapfCalligraphic (Canon)

 	
 127 Spreadsheet (Quadlaser)

 	
 128 Broughm (Brother printers)

 	
 129 Anelia (Brother printers)

 	
 130 LtrGothic (as defined by Brother)

 	
 131 Boldface (Boldface PS)

 	
 132 High Density (NEC)

 	
 133 High Speed (NEC)

 	
 134 Super Focus (NEC P2200)

 	
 135 Swiss Outline (Cordata)

 	
 136 Swiss Display (Cordata)

 	
 137 Momento Outline (Cordata)

 	
 138 Courier Italic (TI 855)

 	
 139 Text Light (Cordata)  0   e6                     

 	
 140 Momento Heavy (Cordata)

 	
 141 BarCode

 	
 142 EAN/UPC

 	
 143 Math-7 (HPLJ)

 	
 144 Math-8 (HPLJ)

 	
 145 Swiss

 	
 146 Dutch

 	
 147 Trend (Nissho)

 	
 148 Holsatia (Qume Laser)

 	
 149 Serif (IBM Pageprinter)

 	
 150 Bandit (Cordata)

 	
 151 Bookman (Cordata)

 	
 152 Casual (Cordata)

 	
 153 Dot (Cordata)

 	
 154 EDP (Epson GQ3500)

 	
 155 ExtGraphics (Epson GQ3500)

 	
 156 Garland (Canon Laser)

 	
 157 PC Line

 	
 158 HP Line

 	
 159 Hamilton (QMS)

 	
 160 Korinna (Cordata)

 	
 161 LineDrw (QMS)

 	
 162 Modern

 	
 163 Momento (Cordata)

 	
 164 MX (Cordata)

 	
 165 PC (Cordata)

 	
 166 PI

 	
 167 Profile (Quadlaser)

 	
 168 Q-Fmt (QMS)

 	
 169 Rule (Cordata)

 	
 170 SB (Cordata)

 	
 171 Taylor (Cordata)                

 	
 172 Text (Cordata)

 	
 173 APL

 	
 174 Artisan

 	
 175 Triumvirate

 	
 176 Chart

 	
 177 Classic

 	
 178 Data

 	
 179 Document

 	
 180 Emperor

 	
 181 Essay

 	
 182 Forms

 	
 183 Facet

 	
 184 Micro (also Microstyle, Eurostile)

 	
 185 OCR-A

 	
 186 OCR-B

 	
 187 Apollo (Blaser)                   0   e6                     

 	
 188 Math

 	
 189 Scientific

 	
 190 Sonoran (IBM Pageprinter)

 	
 191 Square 3

 	
 192 Symbol

 	
 193 Tempora

 	
 194 Title

 	
 195 Titan

 	
 196 Theme

 	
 197 TaxLineDraw

 	
 198 Vintage

 	
 199 XCP

 	
 200 Eletto (Olivetti)

 	
 201 Est Elite (Olivetti)

 	
 202 Idea (Olivetti)

 	
 203 Italico (Olivetti)

 	
 204 Kent (Olivetti)

 	
 205 Mikron (Olivetti)

 	
 206 Notizia (Olivetti)

 	
 207 Roma (Olivetti)

 	
 208 Presentor (Olivetti)

 	
 209 Victoria (Olivetti)

 	
 210 Draft Italic (Olivetti)

 	
 211 PS Capita (Olivetti)

 	
 212 Qual Italic (Olivetti)

 	
 213 Antique Olive (also Provence)

 	
 214 Bauhaus (ITC)

 	
 215 Eras (ITC)

 	
 216 Mincho

 	
 217 SerifGothic (ITC)

 	
 218 Signet Roundhand

 	
 219 Souvenir Gothic

 	
 220 Stymie (ATF)

 	
 221 Bernhard Modern

 	
 222 Grand Ronde Script

 	
 223 Ondine (also Mermaid)

 	
 224 PT Barnum

 	
 225 Kaufmann

 	
 226 Bolt (ITC)

 	
 227 AntOliveCompact (also Provence 

 	dd
 Compact)

 	
 228 Garth Graphic

 	
 229 Ronda (ITC)

 	
 230 EngShcreibschrift

 	
 231 Flash

 	
 232 Gothic Outline (URW)

 	
 233 Akzidenz-Grotesk

 	
 234 TD Logos  0   e6                     

 	
 235 Shannon

 	
 236 Oberon

 	
 237 Callisto

 	
 238 Charter

 	
 239 Plantin

 	
 240 Helvetica Black (PS)

 	
 241 Helvetica Light (PS)

 	
 242 Arnold Bocklin (PS)

 	
 243 Fette Fraktur (PS)

 	
 244 Greek (PS (Universal Greek))

.cp4
.pm 11

 	

 Notes


 	

 3
 		 
 Footnote
.pm 0
.lm 29

 	
 Word: Line count of footnote text.

 	
 Word: Offset to the internal sequence 

 	
 containing the footnote number tag.  

 	
 If there is an internal tag, the high 

 	
 order bit of this word will be set 

 	
 and the low 15 bits will be the 

 	
 offset of the internal sequence.  If 

 	
 the hi order bit is not set, then 

 	
 this number is the footnote number to 

 	
 use.

 	
 Byte: Not used, conversion flag is 

 	
 now in the internal tag symmetrical 

 	
 sequence.  If the footnote contains  

 	
 no tag, then this byte is used for 

 	
 the conversion flag.

 	
 Remaining bytes are for text of the 

 	
 footnote itself.

 	
 The text can contain another sequence 

 	
 of the same format.  This internal 

 	
 sequence is used to display or print 

 	
 the tag associated with the note:                  

 	
 Word: Not used (line count assumed 1)

 	
 Word: Footnote number.

 	
 Byte: Conversion flag.  Normally 0, 

 	
 unless .CV or .F# is used to convert 

 	
 notes from one type or format to 

 	
 another.  The format of the low order 

 	
 nybble of this byte is the same as 

 	
 the numbers for footnotes, endnotes 

 	
 and comments.  If this nybble is 4, 

 	
 convert this note to an endnote.  If 

 	
 6, convert to a comment.

 	
 The high order nybble of this byte is 

 	
 for the format type of the note (al  0   e6                     
 	
 phabetic, numeric, etc.).  0 means to 

 	
 use symbols, 1 is for upper case, 2 

 	
 is for lower case, and three is for 

 	
 numbers.
.pm 11
.lm 26

 	

 4
 		 
 Endnote
.lm 29
.pm 0

 	
 Word: Line count of endnote text.

 	
 Word: Offset to the internal sequence 

 	
 containing the endnote number tag.  

 	
 If there is an internal tag, the high 

 	
 order bit of this word will be set 

 	
 and the low 15 bits will be the 

 	
 offset of the internal sequence.  If 

 	
 the hi order bit is not set, then 

 	
 this number is the endnote number to 

 	
 use.

 	
 Byte: Not used, conversion flag is 

 	
 now in the internal tag symmetrical 

 	
 sequence.  If the footnote contains 

 	
 no tag, then this byte is used for 

 	
 the conversion flag.

 	
 Remaining bytes are for text of the 

 	
 endnote itself.

 	
 The text can contain another sequence 

 	
 of the same format.  This internal 

 	
 sequence is used to display or print 

 	
 the tag associated with the note:                  

 	
 Word: Not used (line count assumed 1)

 	
 Word: Endnote number.

 	
 Byte: Conversion flag.  Normally 0, 

 	
 unless .CV is used to convert notes 

 	
 from one type to another.  The format 

 	
 of the low order nybble of this byte 

 	
 is the same as the numbers for 

 	
 footnotes, endnotes and comments.  If 

 	
 this byte is 3, convert this note to 

 	
 a footnote.  If 6, convert to a 

 	
 comment.

 	
 The high order nybble of this byte is 

 	
 for the format type of the note (al

 	
 phabetic, numeric, etc.).  0 means to 

 	
 use symbols, 1 is for upper case, 2 

 	
 is for lower case, and three is for 

 	
 numbers.

.pm 11
.lm 26

 	

 5
 		 
 Annotation (arbitrary note)
.lm 29
.pm 0

 	
 Word: Line count of annotation text.

 	
 Word: Offset to the internal tag 

 	
 (only the low order 15 bits are used   0   e6                     
 	
 for this, as in footnotes and 

 	
 endnotes).  If the high order bit is 

 	
 set, it indicates that there is an 

 	
 internal tag.  If there is no 

 	
 internal tag, the entire word will be 

 	
 0.

 	
 Byte: Conversion flag.  Not used for 

 	
 annotations.

 	
 Remaining bytes are for text of the 

 	
 annotation itself.

 	
 The text can contain another sequence 

 	
 of the same format.  This internal 

 	
 sequence is used to display or print 

 	
 the tag associated with the note:                  

 	
 Word: Not used (line count assumed 1)

 	
 Word: Not used.

 	
 Remaining bytes are for the text used 

 	
 to display and print the tag of the 

 	
 note (can be null).

 	
 Byte: Conversion flag.  Not used for 

 	
 annotations.

.pm 11
.lm 26

 	

 6
 		 
 Comment
.lm 29
.pm 0

 	
 Word: Line count of the comment.

 	
 Word: Tag offset (not used).

 	
 Byte: Conversion flag.  Normally 0, 

 	
 unless .CV is used to convert notes 

 	
 from one type to another.  The format 

 	
 of the low order nybble of this byte 

 	
 is the same as the numbers for 

 	
 footnotes, endnotes and comments.  If 

 	
 this byte is 4, convert this note to 

 	
 an endnote.  If 3, convert to a foot

 	
 note.

 	
 The high order nybble of this byte is 

 	
 for the format type of the note (al

 	
 phabetic, numeric, etc.).  0 means to 

 	
 use symbols, 1 is for upper case, 2 

 	
 is for lower case, and three is for 

 	
 numbers.

 	
 Since comments don't contain internal 

 	
 tags for display with print control 

 	
 display off, no internal sequence is 

 	
 used, and the remaining bytes are the 

 	
 text of the comment.

.pm 11
.lm 26

 	

 7
 		 
 Reserved.
  0   e6                     

 	

 8
 		 
 Reserved.



 	

 Tabs


 	

 9
 		 
 Tabs and dot leaders
.lm 29
.pm 0

 	
 Word: Tab size in HMIs

 	
 Word: Absolute tab size in HMIs

 	
 Byte: Tab type:  Space for hard tab, 

 	
 soft space for soft tab, '#' for 

 	
 decimal tab.  Also, '!' is used for 

 	
 center line tab, '[' for right align 

 	
 line tab.  Other character such as 

 	
 '.' or '*' are used for dot leaders.

 	
 Byte: Tab size in 1/10th

.pm 11
.lm 26

 	

 0Ah
 	p 
 Reserved.


 	

 0Bh
 	p 
 End of page
.lm 29
.pm 0

 	
 This sequence should usually be 

 	
 ignored.  It's used by the WordStar 

 	
 editor to keep track of page breaks.  

 	
 It is transient, and moves around 

 	
 with the page break.

 	
 Word: Current VMIs on this page

 	
 Word: Line # on page

 	
 Byte: Newspaper type column number

 	
 Byte: # of newspaper type columns in 

 	
 effect.

 	
 Word: VMI placement from top of page 

 	
 where newspaper type columns begin.

 	
 Word: Line number from top of page 

 	
 where newspaper type columns begin.

 	
 Word: Footnote number currently in 

 	
 effect.

 	
 Word: Total VMIs for footnotes on 

 	
 this page.

 	
 Word:  Total VMIs for footnote header 

 	
 and separator lines.

 	
 Word:  VMIs leftover on this page 

 	
 from footnote not completely printed 

 	
 (for running footnotes).

 	
 5 words: Reserved.

.pm 11
.lm 26

 	

 0Ch
 	p 
 Page offset
.lm 29
.pm 0

 	
 Reserved for printer driver use only.  

 	
 Should not appear in files.

 	
 Byte: Number of blanks before line   0   e6                     
 	
 number (0 if no number).

 	
 Word: Absolute HMI spot for line  

 	
 number (0 if no number).

 	
 Byte: Number of blanks after line 

 	
 number.

 	
 Word: Absolute HMI spot for start of 

 	
 text.

 	
 Byte: Number of bytes in line number.

 	
 Bytes: ASCII of line number.

.pm 11
.lm 26

 	

 Others


 	

 0Dh
 	p 
 Paragraph number
.pm 0
.lm 29

 	
 Byte: Number of level moves forward 

 	
 from previous paragraph number. 0 to 

 	
 stay at current level, 1 to move in a 

 	
 level.

 	
 Byte:  Number of level moves back

 	
 wards from previous paragraph number. 

 	
 0 to stay at current level (or 

 	
 forwards if previous byte non- zero), 

 	
 or number of levels moved left (2.1.1 

 	
 going to 3 would mean this byte would 

 	
 be a 2).

 	
 Byte: Level number of this paragraph 

 	
 number (1 based).

 	
 Word: Level 1 number, 0 based.

 	
 Word: Level 2 number, 0 based.

 	
 Word: Level 3 number, 0 based.

 	
 Word: Level 4 number, 0 based.

 	
 Word: Level 5 number, 0 based.

 	
 Word: Level 6 number, 0 based.

 	
 Word: Level 7 number, 0 based.

 	
 Word: Level 8 number, 0 based.

 	
 31 Bytes indicating the format to use 

 	
 for this paragraph number, including 

 	
 a zero terminator.

.pm 11
.lm 26

 	

 0Eh
 	p 
 Index item
.lm 29
.pm 0

 	
 Text for the index item.

.pm 11
.lm 26

 	

 0Fh
 	p 
 User print control
.lm 29
.pm 0

 	
 Word: number of hmis this sequence 

 	
 uses on the printed page.

 	
 Byte: number of characters used for 

 	
 screen display.

 	
 Text: the display string itself.

 	
 The remaining bytes contained in this   0   e6                     
 	
 sequence will be sent directly to the 

 	
 printer.

.pm 11
.lm 26

 	

 10h
 	p 
 Graphics insert
.pm 0
.lm 29

 	
 Text: File name to use for graphics 

 	
 insert.  Length is determined from 

 	
 length of symmetrical sequence.

.pm 11
.lm 26

 	

 11h
 	p 
 Paragraph style
.pm 0
.lm 29

 	
 Word:  New paragraph style number.  

 	
 This number is an index into the doc

 	
 ument's style library.  This is the 

 	
 style that the user just selected.


 	
 Word:  Previously selected paragraph 

 	
 style number.  This is an index into 

 	
 the document's style library of the 

 	
 style previously selected by the 

 	
 user.


 	
 Word:  Previous paragraph 'modified' 

 	
 style number.  This is the current 

 	
 style conditions before this selec

 	
 tion was made.  Because attributes 

 	
 and fonts may have changed since the 

 	
 last style selection was made, new 

 	
 temporary styles must be created in 

 	
 the library to reflect changes.  


 	
 Word:  Previous-previous selected, 

 	
 for reverting.  This is the style se

 	
 lected by the user prior to the 

 	
 previous style.  This is used to 

 	
 revert back to the previous style 

 	
 (^OFP).  This is necessary for 

 	
 WordStar to know the previously 

 	
 selected style when moving backwards 

 	
 in the file without having to keep a 

 	
 list.

.pm 11
.lm 26

 	

 12h-14h
 	 
 Reserved.


 	

 15h
 	p 
 Alternate/Normal font change
.pm 0
.lm 29

 	
 Byte:  Normal = 0, Alternate = 1.

 	
 The rest of the sequence is like a 

 	
 font symmetrical sequence, with the 

 	
 new font characteristics (Width, 

 	
 height, and typestyle), followed by   0   e6                     
 	
 the previous font characteristics.  

 	
 This sequence is inserted by the 

 	
 editor whenever a ^N or ^A is 

 	
 encountered when editing,  or when 

 	
 entering ^PA or ^PN.

.cp 5
.pm 11
.lm 26

 	

 16h
 	p 
 Truncation
.pm 0
.lm 29

 	
 Used when a large symmetrical 

 	
 sequence doesn't fit in ram.  Rather 

 	
 than leave the symmetrical sequence 

 	
 open, it's shortened to fit in ram.  

 	
 Both the leading and trailing count 

 	
 words are adjusted in the offending 

 	
 symmetrical sequence, and this 

 	
 sequence is placed inside the 

 	
 sequence at the end.  This usually 

 	
 will happen with large footnotes or 

 	
 endnotes.  The sequence contains no 

 	
 information (only the count words and 

 	
 the type byte), but gets translated 

 	
 to "<TRUNCATED>" when printed or 

 	
 displayed.

.pm 11
.lm 26

 	

 17h
 	p 
 Japanese Font Shift-In/Shift-Out
.pm 0
.lm 29

 	
 Byte:  Shift-In (to Japanese) = 1, 

 	
 Shift-Out (Back to Normal) = 0.

 	
 Used to change WordStar's 

 	
 interpretation of character codes 

 	
 within the file.  When shifted in, 

 	
 WordStar no longer uses the 1Bh/1Ch 

 	
 wrap characters and interprets 

 	
 characters using the Asian Character 

 	
 Standard which uses 81h-9Fh and E0h-

 	
 FEh for a prefix followed by 20-7Fh 

 	
 to form a complete character (values 

 	
 not in those ranges use only one 

 	
 byte.  Japanese versions of WordStar 

 	
 only.


 	
 18h-0FFh
 	 
 Reserved.


.lm 0
.pm 0
.TB4 2.50" 2.80" 3.20"
Paragraph style libraries

The paragraph style library is kept in three places:

1)
 	  
 WSSTYLE.OVR.  This is the main style library from which 
selections are made.  0   e6                    
  0   e6                    
2)
 	  
 The file being edited contains copies of all styles that are 
used in the document (this library is kept at the end of the 
file.  A 32-bit pointer is placed in the header symmetrical 
sequence which points to the beginning of the document's 
library).

3)
 	  
 A temporary file contains the current working copy of the 
document's styles , which contains the styles from the end of the 
document, the library styles, and temporary styles while editing.


File style library

The header symmetrical sequence contains a 32-bit absolute offset 
into the file where the style library begins (see the description 
of the header symmetrical sequence).  This offset is actually the 
offset of the master index which may be used for structures other 
than paragraph styles.  This offset must be on a sector (128-
byte) boundary.  The structure of the master index follows:

Byte:  1AH -- End of file indicator regardless of WordStar 
filling remainder of last 128-byte sector with 1AH's.

Byte: WordStar style version number in BCD (55H for version 5.5).  
This number will change to reflect the version of WordStar when 
there is a revision in the style library that would cause 
incompatibilities between versions.

Word: Next 512-byte block number available relative to the index 
start, not the document start.

Byte: Number of objects (currently 1, paragraph styles only).


Master index begins here.  It currently consists of only 1 object 
(paragraph styles).

Word: Number of index entries allocated.  This is the number of 
index entries that are available for use in the blocks that have 
been allocated to the master index.

Word: Size of an object entry (102 decimal for paragraph styles).

Double word: Pointer to beginning of object index.  Usually 
points to next byte since paragraph styles are the only object.  
This pointer is relative to the beginning of the master index, 
not the document file itself.
  0   e6                    
  0   e6                    
Object index begins here.

Byte: Number of index entries in this block. (14 for paragraph 
styles)

Double word: Link to next index block.  This pointer is relative 
to the beginning of the master index, not the document file 
itself.


Index items follow:

24 bytes:  Object name (paragraph style name, left justified, 
blank filled)

Byte: Used internally.

Word: Used internally.

Word: Used internally.

Double word: Pointer to style entry.  This pointer is relative to 
the beginning of the master index, not the document file itself.

The above index item is repeated for each indexed entry.  If the 
block is filled with indexes, the link to next index block can be 
used to go to the next set of indexes.


Style entry:

3 words:  Font description.  See the font symmetrical sequence 
description.  First word is -1 if inherited.

2 words: Reserved.

Word: Left margin in HMI, -2 (0fffeh) if inherited.

Word: Right margin in HMI, -2 (0fffeh) if inherited.

Word: Paragraph margin in HMI, -2 (0fffeh) if inherited.

Word: Reserved.

Byte: Number of regular tabs, 0 if inherited (also, first tab 
stop below will be -1).

Byte: Number of decimal tabs, 0 if inherited (also, first tab   0   e6                     stop below will be -1).

32 words: Tab stops in HMIs.  Regular tabs are first.  If first 
tab stop is -1 (0ffffh), then tabs are inherited.

Word: Reserved.

Byte: Justification flag.  0 means no justification, -1 means 
inherit, 1 means right justified, -2 means centered, and -3 means 
flush right.

Byte: Word wrap flag.  1 means word wrap is on, 0 is off, -1 
means inherit.

Word: Line height in VMI, -1 = inherit.

Byte: Line spacing (1-9), -1 = inherit.

2 Words:  Print attributes on, off.  Bits set in the first word 
indicate those attributes are explicitly set to the on state.  
Bits set in the second word indicate those attributes are 
explicitly set off.  If both corresponding bits are off, then the 
attribute is inherited from the current state.  Descriptions of 
the bits are as follows:

Strikeout
 	@ 
 000000000000001B
Doublestrike
 	$	 
 000000000000010B

Underlining
 		 
 000000000001000B
Subscript
 	@ 
 000000000010000B
Superscript
 		 
 000000000100000B
Bold
 	 
 000000001000000B
Italics
 	 
 000000010000000B

Byte: Color.  See a description of the color symmetrical 
sequence.  -1 means inherited.

6 Bytes: Reserved.
.pa  '   e6                     
